/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.config.properties.types;

import com.google.common.collect.Lists;
import io.lumine.mythic.bukkit.utils.config.properties.PropertyType;
import io.lumine.mythic.bukkit.utils.config.properties.types.StringListProp;
import io.lumine.mythic.bukkit.utils.items.ItemFactory;
import io.lumine.mythic.bukkit.utils.plugin.LuminePlugin;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class LineItemListProp
extends PropertyType<List<ItemStack>> {
    private List<ItemStack> defaultValue;
    private StringListProp LIST;

    public LineItemListProp(LuminePlugin plugin, Object file, String node) {
        super(plugin, file, node);
        this.LIST = new StringListProp(plugin, file, node);
        this.defaultValue = Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(Material.STONE)});
    }

    public LineItemListProp(LuminePlugin plugin, Object file, String node, List<ItemStack> defaultValue) {
        super(plugin, file, node);
        this.LIST = new StringListProp(plugin, file, node);
        this.defaultValue = defaultValue;
    }

    @Override
    protected List<ItemStack> compute(ConfigurationSection section, String node) {
        if (section == null) {
            return this.defaultValue;
        }
        ArrayList items = Lists.newArrayList();
        for (String line : (List)this.LIST.get(section)) {
            items.add(ItemFactory.of(line).build());
        }
        return items;
    }

    @Override
    public void set(String holder, List<ItemStack> value) {
        if (this.config == null) {
            return;
        }
    }

    @Override
    public List<ItemStack> getDefaultValue() {
        return this.defaultValue;
    }
}

