/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.utils.config.properties.types;

import io.lumine.mythic.bukkit.utils.config.properties.PropertyType;
import io.lumine.mythic.bukkit.utils.plugin.LuminePlugin;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class EnumProp<T extends Enum<T>>
extends PropertyType<T> {
    private final Class<T> clazz;
    private final T defaultValue;

    public EnumProp(LuminePlugin plugin, Object file, Class<T> clazz, String node) {
        super(plugin, file, node);
        this.clazz = clazz;
        this.defaultValue = null;
    }

    public EnumProp(LuminePlugin plugin, Object file, Class<T> clazz, String node, T defaultValue) {
        super(plugin, file, node);
        this.clazz = clazz;
        this.defaultValue = defaultValue;
    }

    @Override
    protected T compute(ConfigurationSection section, String node) {
        if (section == null) {
            return this.defaultValue;
        }
        try {
            T value = Enum.valueOf(this.clazz, section.getString(node));
            if (value == null) {
                return this.defaultValue;
            }
            return value;
        }
        catch (Error | Exception ex) {
            return this.defaultValue;
        }
    }

    @Override
    public void set(String holder, T value) {
        if (this.config == null) {
            return;
        }
        if (holder != null) {
            this.config.set(holder + "." + this.node, (Object)((Enum)value).toString());
        } else {
            this.config.set(this.node, (Object)((Enum)value).toString());
        }
        try {
            ((FileConfiguration)this.config).save(this.plugin.getPropertyFile(this.file));
        }
        catch (Error | Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }
}

