/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.volatilecode.VolatileAttribute;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.core.logging.MythicLogger;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;
import org.bukkit.entity.ZombieVillager;

public class BukkitZombieVillager
extends BukkitEntityType {
    private double reinforcementChance = -1.0;
    private Villager.Profession villagerProfession;
    private Villager.Type villagerType;

    @Override
    public EntityType getBukkitType() {
        return EntityType.ZOMBIE_VILLAGER;
    }

    @Override
    public int getHeight() {
        return 2;
    }

    @Override
    public void instantiate(MythicConfig mc) {
        this.reinforcementChance = mc.getDouble("Options.ReinforcementsChance", -1.0);
        String prof = mc.getNamespacedString("Options.Profession", "nitwit");
        this.villagerProfession = (Villager.Profession)Registry.VILLAGER_PROFESSION.get(NamespacedKey.fromString((String)prof));
        if (prof != null && this.villagerProfession == null) {
            MythicLogger.errorEntityConfig(this, mc, "Invalid villager profession configured");
        }
        String type = mc.getNamespacedString("Options.Type", "plains");
        this.villagerType = (Villager.Type)Registry.VILLAGER_TYPE.get(NamespacedKey.fromString((String)prof));
        if (type != null && this.villagerType == null) {
            MythicLogger.errorEntityConfig(this, mc, "Invalid villager type configured");
        }
    }

    @Override
    public Entity applyOptions(Entity entity) {
        ZombieVillager e = (ZombieVillager)entity;
        e.setBaby(false);
        if (this.villagerProfession != null) {
            e.setVillagerProfession(this.villagerProfession);
        }
        if (this.villagerType != null) {
            e.setVillagerType(this.villagerType);
        }
        if (this.reinforcementChance >= 0.0) {
            e.getAttribute(VolatileAttribute.SPAWN_REINFORCEMENTS).setBaseValue(this.reinforcementChance);
        }
        return e;
    }
}

