/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.entities.properties.AgeableProperty;
import io.lumine.mythic.bukkit.entities.properties.TameableEntityType;
import io.lumine.mythic.bukkit.entities.properties.TameableProperty;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fox;

public class BukkitFox
extends BukkitEntityType
implements TameableEntityType {
    private AgeableProperty ageableProperty;
    private TameableProperty tameableProperty;
    private String foxType;

    @Override
    public EntityType getBukkitType() {
        return EntityType.FOX;
    }

    @Override
    public int getHeight() {
        return 1;
    }

    @Override
    public void instantiate(MythicConfig mc) {
        this.ageableProperty = new AgeableProperty(mc);
        this.foxType = mc.getString("Options.FoxType", null);
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Fox e = (Fox)entity;
        this.ageableProperty.applyProperties(entity);
        if (this.foxType != null) {
            e.setFoxType(Fox.Type.valueOf((String)this.foxType));
        }
        return e;
    }

    public AgeableProperty getAgeableProperty() {
        return this.ageableProperty;
    }

    @Override
    public TameableProperty getTameableProperty() {
        return this.tameableProperty;
    }

    public String getFoxType() {
        return this.foxType;
    }
}

