/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.entities.properties.AgeableProperty;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class BukkitCow
extends BukkitEntityType {
    private NamespacedKey variant;

    @Override
    public EntityType getBukkitType() {
        return EntityType.COW;
    }

    @Override
    public int getHeight() {
        return 2;
    }

    @Override
    public void instantiate(MythicConfig mc) {
        this.registerProperty(new AgeableProperty(mc));
        String variant = mc.getNamespacedString(new String[]{"Variant", "Options.Variant"}, null, new String[0]);
        if (variant != null) {
            this.variant = NamespacedKey.fromString((String)variant);
        }
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Cow.Variant variant;
        Cow e = (Cow)entity;
        if (this.variant != null && (variant = (Cow.Variant)RegistryAccess.registryAccess().getRegistry(RegistryKey.COW_VARIANT).get(this.variant)) != null) {
            e.setVariant(variant);
        }
        return e;
    }
}

