/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.entities;

import com.google.common.collect.Sets;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.bukkit.entities.properties.AgeableProperty;
import io.lumine.mythic.bukkit.entities.properties.TameableEntityType;
import io.lumine.mythic.bukkit.entities.properties.TameableProperty;
import io.lumine.mythic.bukkit.utils.items.ItemFactory;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public class BukkitAxolotl
extends BukkitEntityType
implements TameableEntityType {
    private final String headString = "";
    private final ItemStack head = ItemFactory.of(Material.AXOLOTL_BUCKET).build();
    private TameableProperty tameableProperty;
    private boolean tameable;
    private String type;

    @Override
    public EntityType getBukkitType() {
        return EntityType.AXOLOTL;
    }

    @Override
    public int getHeight() {
        return 1;
    }

    @Override
    public void instantiate(MythicConfig mc) {
        this.registerProperty(new AgeableProperty(mc));
        this.tameableProperty = new TameableProperty(mc, (Set<Material>)Sets.immutableEnumSet((Enum)Material.WATER_BUCKET, (Enum[])new Material[]{Material.TROPICAL_FISH_BUCKET}));
        this.tameable = mc.getBoolean("Options.Tameable", false);
        this.type = mc.getString("Options.Type", null);
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Axolotl e = (Axolotl)entity;
        if (this.type != null) {
            e.setVariant(Axolotl.Variant.valueOf((String)this.type.toUpperCase()));
        }
        return e;
    }

    @Override
    public String getHeadString() {
        return this.headString;
    }

    @Override
    public ItemStack getHead() {
        return this.head;
    }

    @Override
    public TameableProperty getTameableProperty() {
        return this.tameableProperty;
    }

    public boolean isTameable() {
        return this.tameable;
    }
}

