/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.compatibility;

import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import net.crashcraft.crashclaim.CrashClaim;
import net.crashcraft.crashclaim.claimobjects.Claim;
import org.bukkit.Location;
import org.bukkit.plugin.java.JavaPlugin;

public class CrashClaimSupport {
    private final MythicBukkit core;
    private CrashClaim crashClaim;

    public CrashClaimSupport(MythicBukkit mm4) {
        this.core = mm4;
        this.crashClaim = (CrashClaim)JavaPlugin.getPlugin(CrashClaim.class);
        if (this.crashClaim == null) {
            return;
        }
    }

    public boolean isLocationClaimed(AbstractLocation aLocation) {
        Location location = BukkitAdapter.adapt(aLocation);
        Claim claim = this.crashClaim.getDataManager().getClaim(location);
        return claim != null;
    }

    public boolean isNearClaim(AbstractLocation aLocation, int radius) {
        Location location = BukkitAdapter.adapt(aLocation);
        int smallX = Numbers.floor((location.getX() - (double)radius) / 16.0);
        int bigX = Numbers.floor((location.getX() + (double)radius) / 16.0);
        int smallZ = Numbers.floor((location.getZ() - (double)radius) / 16.0);
        int bigZ = Numbers.floor((location.getZ() + (double)radius) / 16.0);
        for (int x = smallX; x <= bigX; ++x) {
            for (int z = smallZ; z <= bigZ; ++z) {
                if (this.crashClaim.getDataManager().getClaims((long)x, (long)z, location.getWorld().getUID()).size() <= 0) continue;
                return true;
            }
        }
        return false;
    }
}

