/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.commands.spawners;

import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.CollectionUtils;
import io.lumine.mythic.bukkit.utils.chat.ColorString;
import io.lumine.mythic.bukkit.utils.commands.Command;
import io.lumine.mythic.core.spawning.spawners.MythicSpawner;
import io.lumine.mythic.core.spawning.spawners.SpawnerAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class SetCommand
extends Command<MythicBukkit> {
    public SetCommand(Command<MythicBukkit> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        if (args.length < 3) {
            sender.sendMessage(ColorString.get("&6--====|||| &c&lMythicMobs &6||||====--"));
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Command: " + String.valueOf(ChatColor.AQUA) + "/mm spawners set [name] [attribute] [value]");
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + String.valueOf(ChatColor.BOLD) + "Available Attributes:");
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "activationrange" + String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.ITALIC) + " - The max range a player can be for the spawner to activate.");
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "cooldown" + String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.ITALIC) + " - The time (in seconds) between mob spawns.");
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "group" + String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.ITALIC) + " - The name of a group to organize the spawner into.");
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "healonleash" + String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.ITALIC) + " - (true/false) Whether or not a mob will heal to full health upon being leashed.");
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "leashrange" + String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.ITALIC) + " - The max range a mob can be from the spawner before it is teleported back (0=none).");
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "maxmobs" + String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.ITALIC) + " - The maximum number of mobs this spawner can have active at once.");
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "moblevel" + String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.ITALIC) + " - The level of the mobs spawned by the spawner.");
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "mobsperspawn" + String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.ITALIC) + " - How many mobs will spawn per spawner cycle.");
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "resetthreatonleash" + String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.ITALIC) + " - (true/false) Whether or not the mob's target should be reset upon being leashed.");
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "showflames" + String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.ITALIC) + " - (true/false) whether to always show spawner flames on the block.");
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "usetimer" + String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.ITALIC) + " - (true/false) whether the spawner should spawn on a timer or not..");
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "warmup" + String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.ITALIC) + " - The time (in seconds) until a mob spawns after a mob dies, when the max number of mobs has been reached.");
            return true;
        }
        String name = args[0];
        String option = args[1];
        Object value = "";
        for (int i = 2; i < args.length; ++i) {
            value = ((String)value).concat(args[i]) + " ";
        }
        if (name.startsWith("g:")) {
            String group = name.substring(2);
            ArrayList<MythicSpawner> msl = MythicBukkit.inst().getSpawnerManager().getSpawnersByGroup(group);
            for (MythicSpawner ms : msl) {
                if (MythicBukkit.inst().getSpawnerManager().setSpawnerAttribute(ms, option, (String)value)) continue;
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "[MythicMobs] " + String.valueOf(ChatColor.RED) + "The attribute or value you entered was invalid!");
                return true;
            }
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "[MythicMobs] " + String.valueOf(ChatColor.GREEN) + "Spawner attribute " + String.valueOf(ChatColor.AQUA) + option + String.valueOf(ChatColor.GREEN) + " set to " + String.valueOf(ChatColor.AQUA) + (String)value + String.valueOf(ChatColor.GREEN) + " on group " + group);
        } else if (name.equals("*")) {
            for (MythicSpawner ms : MythicBukkit.inst().getSpawnerManager().getSpawners()) {
                if (MythicBukkit.inst().getSpawnerManager().setSpawnerAttribute(ms, option, (String)value)) continue;
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "[MythicMobs] " + String.valueOf(ChatColor.RED) + "The condition you entered was invalid!");
                return true;
            }
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "[MythicMobs] Spawner attribute " + String.valueOf(ChatColor.AQUA) + option + String.valueOf(ChatColor.GREEN) + " set to " + String.valueOf(ChatColor.AQUA) + (String)value + String.valueOf(ChatColor.GREEN) + " on all spawners!");
        } else if (name.contains("*") || name.contains("?")) {
            for (MythicSpawner ms : MythicBukkit.inst().getSpawnerManager().getSpawners()) {
                if (!ms.getName().matches(name.replace("?", ".?").replace("*", ".*?")) || MythicBukkit.inst().getSpawnerManager().setSpawnerAttribute(ms, option, (String)value)) continue;
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "[MythicMobs] " + String.valueOf(ChatColor.RED) + "The condition you entered was invalid!");
                return true;
            }
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "[MythicMobs] Spawner attribute " + String.valueOf(ChatColor.AQUA) + option + String.valueOf(ChatColor.GREEN) + " set to " + String.valueOf(ChatColor.AQUA) + (String)value + String.valueOf(ChatColor.GREEN) + " on spawners matching pattern " + name + "!");
        } else {
            MythicSpawner ms = MythicBukkit.inst().getSpawnerManager().getSpawnerByName(name);
            if (ms == null) {
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "[MythicMobs] " + String.valueOf(ChatColor.RED) + "You must enter a valid Mythic Spawner. That one was not found!");
                return true;
            }
            if (!MythicBukkit.inst().getSpawnerManager().setSpawnerAttribute(ms, option, (String)value)) {
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "[MythicMobs] " + String.valueOf(ChatColor.RED) + "The attribute or value you entered was invalid!");
            } else {
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "[MythicMobs] " + String.valueOf(ChatColor.GREEN) + "Spawner attribute " + String.valueOf(ChatColor.AQUA) + option + String.valueOf(ChatColor.GREEN) + " set to " + String.valueOf(ChatColor.AQUA) + (String)value + " on spawner " + name);
            }
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            return CollectionUtils.filterMatches(args[0], ((MythicBukkit)this.getPlugin()).getSpawnerManager().getSpawners().stream().map(s2 -> s2.getInternalName()).toList(), 2);
        }
        if (args.length == 2) {
            List<String> attributes = Arrays.stream(SpawnerAttribute.values()).map(a -> a.toString().toLowerCase()).toList();
            return CollectionUtils.filterMatches(args[1], attributes, 2);
        }
        return Collections.emptyList();
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.spawners.set";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "set";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"s"};
    }
}

