/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.commands.spawners;

import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.utils.CollectionUtils;
import io.lumine.mythic.bukkit.utils.commands.Command;
import io.lumine.mythic.core.spawning.spawners.MythicSpawner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;

public class RemoveConditionSpawnCommand
extends Command<MythicBukkit> {
    public RemoveConditionSpawnCommand(Command<MythicBukkit> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        if (args.length < 2) {
            CommandHelper.sendError(sender, "Invalid Syntax: <aqua>/mm spawners removespawncondition [spawner] [condition]");
            return true;
        }
        String name = args[0];
        String condition = args[1];
        if (name.startsWith("g:")) {
            String group = name.substring(2);
            ArrayList<MythicSpawner> msl = MythicBukkit.inst().getSpawnerManager().getSpawnersByGroup(group);
            for (MythicSpawner ms : msl) {
                if (ms.removeTargetCondition(condition)) continue;
                CommandHelper.sendError(sender, "The condition you entered was invalid!");
                return true;
            }
            CommandHelper.sendSuccess(sender, "Removed spawn condition <aqua>" + condition + "<green> on group <yellow>" + group);
        } else if (name.equals("*")) {
            for (MythicSpawner ms : ((MythicBukkit)this.getPlugin()).getSpawnerManager().getSpawners()) {
                if (ms.removeTargetCondition(condition)) continue;
                CommandHelper.sendError(sender, "The condition you entered was invalid!");
                return true;
            }
            CommandHelper.sendSuccess(sender, "Spawn condition <aqua>" + condition + "<green> removed from all spawners!");
        } else if (name.contains("*") || name.contains("?")) {
            for (MythicSpawner ms : ((MythicBukkit)this.getPlugin()).getSpawnerManager().getSpawners()) {
                if (!ms.getName().matches(name.replace("?", ".?").replace("*", ".*?")) || ms.removeTargetCondition(condition)) continue;
                CommandHelper.sendError(sender, "The condition you entered was invalid!");
                return true;
            }
            CommandHelper.sendSuccess(sender, "Spawn condition <aqua>" + condition + "<green> removed from spawners matching pattern <yellow>" + name + "!");
        } else {
            MythicSpawner ms = ((MythicBukkit)this.getPlugin()).getSpawnerManager().getSpawnerByName(name);
            if (ms == null) {
                CommandHelper.sendError(sender, "You must enter a valid Mythic Spawner ID. That one was not found!");
                return true;
            }
            if (!ms.removeTargetCondition(condition)) {
                CommandHelper.sendError(sender, "The condition you entered was invalid!");
            } else {
                CommandHelper.sendSuccess(sender, "Removed spawn condition <aqua>" + condition);
            }
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            return CollectionUtils.filterMatches(args[0], ((MythicBukkit)this.getPlugin()).getSpawnerManager().getSpawners().stream().map(s2 -> s2.getInternalName()).toList(), 2);
        }
        return Collections.emptyList();
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.spawners.removecondition";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "removespawncondition";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"rsc"};
    }
}

