/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.commands.spawners;

import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.utils.CollectionUtils;
import io.lumine.mythic.bukkit.utils.commands.Command;
import io.lumine.mythic.core.spawning.spawners.MythicSpawner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;

public class AddConditionSpawnCommand
extends Command<MythicBukkit> {
    public AddConditionSpawnCommand(Command<MythicBukkit> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        if (args.length < 2) {
            CommandHelper.sendError(sender, "Invalid Syntax: <aqua>/mm spawners addspawncondition [spawner] [condition]");
            return true;
        }
        String name = args[0];
        Object condition = "";
        for (int i = 1; i < args.length; ++i) {
            condition = ((String)condition).concat(args[i]) + " ";
        }
        if (name.startsWith("g:")) {
            String group = name.substring(2);
            ArrayList<MythicSpawner> msl = ((MythicBukkit)this.getPlugin()).getSpawnerManager().getSpawnersByGroup(group);
            for (MythicSpawner ms : msl) {
                if (ms.addTargetCondition((String)condition)) continue;
                CommandHelper.sendError(sender, "The condition you entered was invalid!");
                return true;
            }
            CommandHelper.sendSuccess(sender, "Added spawn condition <aqua>" + (String)condition + "<green> on group <yellow>" + group);
        } else if (name.equals("*")) {
            for (MythicSpawner ms : ((MythicBukkit)this.getPlugin()).getSpawnerManager().getSpawners()) {
                if (ms.addTargetCondition((String)condition)) continue;
                CommandHelper.sendError(sender, "The condition you entered was invalid!");
                return true;
            }
            CommandHelper.sendSuccess(sender, "Spawn condition <aqua>" + (String)condition + "<green> added to all spawners!");
        } else if (name.contains("*") || name.contains("?")) {
            for (MythicSpawner ms : ((MythicBukkit)this.getPlugin()).getSpawnerManager().getSpawners()) {
                if (!ms.getName().matches(name.replace("?", ".?").replace("*", ".*?")) || ms.addTargetCondition((String)condition)) continue;
                CommandHelper.sendError(sender, "The condition you entered was invalid!");
                return true;
            }
            CommandHelper.sendSuccess(sender, "Spawn condition <aqua>" + (String)condition + "<green> added to spawners matching pattern <yellow>" + name + "!");
        } else {
            MythicSpawner ms = ((MythicBukkit)this.getPlugin()).getSpawnerManager().getSpawnerByName(name);
            if (ms == null) {
                CommandHelper.sendError(sender, "You must enter a valid Mythic Spawner ID. That one was not found!");
                return true;
            }
            if (!ms.addTargetCondition((String)condition)) {
                CommandHelper.sendError(sender, "The condition you entered was invalid!");
            } else {
                CommandHelper.sendSuccess(sender, "Added spawn condition <aqua>" + (String)condition);
            }
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            return CollectionUtils.filterMatches(args[0], ((MythicBukkit)this.getPlugin()).getSpawnerManager().getSpawners().stream().map(s2 -> s2.getInternalName()).toList(), 2);
        }
        if (args.length == 2) {
            return CollectionUtils.filterMatches(args[0], (Collection<String>)((MythicBukkit)this.getPlugin()).getSkillManager().getConditions().keySet(), 2);
        }
        return Collections.emptyList();
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.spawners.addcondition";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "addspawncondition";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"asc"};
    }
}

