/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.commands.items;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.commands.CommandHelper;
import io.lumine.mythic.bukkit.utils.commands.Command;
import io.lumine.mythic.bukkit.utils.text.Text;
import io.lumine.mythic.core.config.MythicConfigImpl;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.core.utils.jnbt.ByteArrayTag;
import io.lumine.mythic.core.utils.jnbt.ByteTag;
import io.lumine.mythic.core.utils.jnbt.CompoundTag;
import io.lumine.mythic.core.utils.jnbt.DoubleTag;
import io.lumine.mythic.core.utils.jnbt.FloatTag;
import io.lumine.mythic.core.utils.jnbt.IntArrayTag;
import io.lumine.mythic.core.utils.jnbt.IntTag;
import io.lumine.mythic.core.utils.jnbt.ListTag;
import io.lumine.mythic.core.utils.jnbt.LongTag;
import io.lumine.mythic.core.utils.jnbt.ShortTag;
import io.lumine.mythic.core.utils.jnbt.StringTag;
import io.lumine.mythic.core.utils.jnbt.Tag;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.CustomModelData;
import io.papermc.paper.datacomponent.item.ItemEnchantments;
import io.papermc.paper.datacomponent.item.ItemLore;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ImportCommand
extends Command<MythicBukkit> {
    public ImportCommand(Command<MythicBukkit> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        CompoundTag nbt;
        ItemLore data;
        ArrayList lines;
        File file;
        Player player;
        ItemStack item;
        if (args.length < 1) {
            CommandHelper.sendError(sender, "You must specify a name for this item.");
            return true;
        }
        String name = args[0];
        Object fileName = name + ".yml";
        if (args.length > 1) {
            fileName = args[1];
        }
        if ((item = (player = (Player)sender).getInventory().getItemInHand()) == null || item.getType() == Material.AIR) {
            CommandHelper.sendError(sender, "You must be holding an item to import.");
            return true;
        }
        File basePath = ((MythicBukkit)this.plugin).getDataFolder();
        File itemsFolder = new File(basePath, "items");
        if (!(itemsFolder.exists() && itemsFolder.isDirectory() || (itemsFolder = new File(basePath, "Items")).exists() && itemsFolder.isDirectory())) {
            itemsFolder = new File(basePath, "items");
            itemsFolder.mkdir();
        }
        if (!((String)fileName).endsWith(".yml")) {
            fileName = (String)fileName + ".yml";
        }
        if (!(file = new File(itemsFolder, (String)fileName)).exists()) {
            try {
                if (!file.createNewFile()) {
                    CommandHelper.sendError(sender, "Failed to create new file for Item Import.");
                    return true;
                }
            }
            catch (IOException e) {
                CommandHelper.sendError(sender, "Failed to create new file for Item Import.");
                e.printStackTrace();
            }
        }
        MythicConfigImpl mc = new MythicConfigImpl(name, file);
        mc.load();
        mc.set("Material", item.getType().toString());
        if (item.hasData((DataComponentType)DataComponentTypes.ITEM_MODEL)) {
            mc.set("Model", ((Key)item.getData(DataComponentTypes.ITEM_MODEL)).toString());
        }
        if (item.hasData((DataComponentType)DataComponentTypes.CUSTOM_MODEL_DATA)) {
            Object d;
            CustomModelData data2 = (CustomModelData)item.getData(DataComponentTypes.CUSTOM_MODEL_DATA);
            Iterator iterator = data2.floats().iterator();
            if (iterator.hasNext()) {
                d = (Float)iterator.next();
                mc.set("CustomModelData", d);
            }
            if ((iterator = data2.strings().iterator()).hasNext()) {
                d = (String)iterator.next();
                mc.set("CustomModelData", d);
            }
        }
        if (item.hasData((DataComponentType)DataComponentTypes.CUSTOM_NAME)) {
            Component component = (Component)item.getData(DataComponentTypes.CUSTOM_NAME);
            mc.set("Display", Text.toReadable(component));
        }
        if (item.hasData((DataComponentType)DataComponentTypes.LORE)) {
            lines = Lists.newArrayList();
            data = (ItemLore)item.getData(DataComponentTypes.LORE);
            for (Component component : data.lines()) {
                lines.add(Text.toReadable(component));
            }
            mc.set("Lore", lines);
        }
        if (item.hasData((DataComponentType)DataComponentTypes.DAMAGE)) {
            mc.set("Damage", item.getData(DataComponentTypes.DAMAGE));
        }
        if (item.hasData((DataComponentType)DataComponentTypes.ENCHANTMENTS)) {
            lines = Lists.newArrayList();
            data = (ItemEnchantments)item.getData(DataComponentTypes.ENCHANTMENTS);
            for (Map.Entry entry : data.enchantments().entrySet()) {
                String key = ((Enchantment)entry.getKey()).getKey().toString();
                Integer level = (Integer)entry.getValue();
                lines.add(key + ": " + level);
            }
            mc.set("Enchantments", lines);
        }
        if ((nbt = ((MythicBukkit)this.getPlugin()).getVolatileCodeHandler().getItemHandler().getNBTData(item)) != null && !nbt.getValue().isEmpty()) {
            ImportCommand.importNBT(mc, "NBT", nbt);
        }
        mc.save();
        MythicItem mi = new MythicItem(((MythicBukkit)this.getPlugin()).getPackManager().getBasePack(), file, name, mc);
        ((MythicBukkit)this.getPlugin()).getItemManager().registerItem(name, mi);
        CommandHelper.sendSuccess(sender, "Item '" + name + "' imported successfully to file " + (String)fileName);
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.items.import";
    }

    @Override
    public boolean isConsoleFriendly() {
        return false;
    }

    @Override
    public String getName() {
        return "import";
    }

    private static void importNBT(MythicConfig mc, String parentKey, CompoundTag compoundTag) {
        for (Map.Entry entry : compoundTag.getValue().entrySet()) {
            String key = (String)entry.getKey();
            Tag tag = (Tag)entry.getValue();
            String path = parentKey == null || parentKey.isEmpty() ? key : parentKey + "." + key;
            ImportCommand.writeTag(mc, path, tag);
        }
    }

    private static void writeTag(MythicConfig mc, String path, Tag tag) {
        if (tag instanceof CompoundTag) {
            CompoundTag ct = (CompoundTag)tag;
            ImportCommand.importNBT(mc, path, ct);
            return;
        }
        if (tag instanceof ListTag) {
            ListTag lt = (ListTag)tag;
            ImportCommand.writeList(mc, path, lt);
            return;
        }
        if (tag instanceof StringTag) {
            StringTag st = (StringTag)tag;
            mc.set(path, st.getValue());
        } else if (tag instanceof IntTag) {
            IntTag it = (IntTag)tag;
            mc.set(path, "int/" + it.getValue());
        } else if (tag instanceof LongTag) {
            LongTag ltg = (LongTag)tag;
            mc.set(path, "long/" + ltg.getValue());
        } else if (tag instanceof ShortTag) {
            ShortTag sht = (ShortTag)tag;
            mc.set(path, "short/" + sht.getValue());
        } else if (tag instanceof ByteTag) {
            ByteTag bt = (ByteTag)tag;
            mc.set(path, "byte/" + bt.getValue());
        } else if (tag instanceof FloatTag) {
            FloatTag ft = (FloatTag)tag;
            mc.set(path, "float/" + ft.getValue());
        } else if (tag instanceof DoubleTag) {
            DoubleTag dt = (DoubleTag)tag;
            mc.set(path, "double/" + dt.getValue());
        } else if (tag instanceof IntArrayTag) {
            IntArrayTag iat = (IntArrayTag)tag;
            int[] arr = iat.getValue();
            List out = Arrays.stream(arr).mapToObj(i -> "int/" + i).collect(Collectors.toList());
            mc.set(path, out);
        } else if (tag instanceof ByteArrayTag) {
            ByteArrayTag bat = (ByteArrayTag)tag;
            byte[] arr = bat.getValue();
            ArrayList<CallSite> out = new ArrayList<CallSite>(arr.length);
            for (byte b : arr) {
                out.add((CallSite)((Object)("byte/" + b)));
            }
            mc.set(path, out);
        } else {
            mc.set(path, String.valueOf(tag.getValue()));
        }
    }

    private static void writeList(MythicConfig mc, String path, ListTag list) {
        Object values = list.getValue();
        if (values.isEmpty()) {
            mc.set(path, Collections.emptyList());
            return;
        }
        if (values.get(0) instanceof CompoundTag) {
            for (int i = 0; i < values.size(); ++i) {
                Tag t2 = (Tag)values.get(i);
                if (!(t2 instanceof CompoundTag)) {
                    mc.set(path, values.stream().map(ImportCommand::scalarFor).collect(Collectors.toList()));
                    return;
                }
                CompoundTag ct = (CompoundTag)t2;
                ImportCommand.importNBT(mc, path + "." + i, ct);
            }
            return;
        }
        ArrayList<Object> out = new ArrayList<Object>(values.size());
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            Tag t3 = (Tag)iterator.next();
            out.add(ImportCommand.scalarFor(t3));
        }
        mc.set(path, out);
    }

    private static Object scalarFor(Tag t2) {
        if (t2 instanceof StringTag) {
            StringTag st = (StringTag)t2;
            return st.getValue();
        }
        if (t2 instanceof IntTag) {
            IntTag it = (IntTag)t2;
            return "int/" + it.getValue();
        }
        if (t2 instanceof LongTag) {
            LongTag ltg = (LongTag)t2;
            return "long/" + ltg.getValue();
        }
        if (t2 instanceof ShortTag) {
            ShortTag sht = (ShortTag)t2;
            return "short/" + sht.getValue();
        }
        if (t2 instanceof ByteTag) {
            ByteTag bt = (ByteTag)t2;
            return "byte/" + bt.getValue();
        }
        if (t2 instanceof FloatTag) {
            FloatTag ft = (FloatTag)t2;
            return "float/" + ft.getValue();
        }
        if (t2 instanceof DoubleTag) {
            DoubleTag dt = (DoubleTag)t2;
            return "double/" + dt.getValue();
        }
        if (t2 instanceof ByteArrayTag) {
            return "<byte-array>";
        }
        if (t2 instanceof IntArrayTag) {
            return "<int-array>";
        }
        if (t2 instanceof CompoundTag) {
            return "<compound>";
        }
        if (t2 instanceof ListTag) {
            return "<list>";
        }
        return String.valueOf(t2.getValue());
    }
}

