/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit.adapters;

import com.google.common.collect.Sets;
import io.lumine.mythic.api.adapters.AbstractBlock;
import io.lumine.mythic.api.adapters.AbstractBlockMatcher;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.logging.MythicLogger;
import java.util.Collection;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;

public class BukkitBlockMatcher
extends AbstractBlockMatcher {
    private final Collection<Material> materials = Sets.newHashSet();
    private final Collection<BlockData> specificBlocks = Sets.newHashSet();
    private final Collection<Tag<Material>> tags = Sets.newHashSet();

    public BukkitBlockMatcher(String filter) {
        String[] split;
        for (String line : split = filter.split(",")) {
            try {
                this.parse(line);
            }
            catch (Throwable ex) {
                MythicLogger.error("Failed to parse BlockMatcher element {0}", line);
                ex.printStackTrace();
            }
        }
    }

    public BukkitBlockMatcher(Collection<String> filter) {
        for (String line : filter) {
            try {
                this.parse(line);
            }
            catch (Throwable ex) {
                MythicLogger.error("Failed to parse BlockMatcher element {0}", line);
                ex.printStackTrace();
            }
        }
    }

    private void parse(String filter) {
        Material material;
        if (filter == null || ((String)filter).isEmpty()) {
            return;
        }
        if (((String)filter).startsWith("#")) {
            NamespacedKey tagKey;
            Tag tag;
            if (!((String)(filter = ((String)filter).substring(1))).contains(":")) {
                filter = "minecraft:" + (String)filter;
            }
            if ((tag = Bukkit.getTag((String)"blocks", (NamespacedKey)(tagKey = NamespacedKey.fromString((String)filter)), Material.class)) == null) {
                MythicLogger.error("[BlockType] BlockTag '#" + String.valueOf(tagKey) + "' does not exist");
                return;
            }
            this.tags.add((Tag<Material>)tag);
            return;
        }
        if (((String)filter).contains("*")) {
            int wildcardIndex = ((String)filter).indexOf(42);
            String before = ((String)filter).substring(0, wildcardIndex);
            String after = ((String)filter).substring(wildcardIndex + 1);
            String regex = "^" + Pattern.quote(before).toUpperCase() + ".*" + Pattern.quote(after).toUpperCase() + "$";
            Pattern pattern = Pattern.compile(regex);
            for (Material material2 : Material.values()) {
                String materialName = material2.toString().toUpperCase();
                if (!pattern.matcher(materialName).matches()) continue;
                this.materials.add(material2);
            }
        } else if (((String)filter).contains("[")) {
            try {
                BlockData blockData = Bukkit.createBlockData((String)((String)filter).toLowerCase());
                if (blockData != null) {
                    this.specificBlocks.add(blockData);
                    return;
                }
            }
            catch (Exception exception) {
                return;
            }
        }
        if ((material = Material.getMaterial((String)((String)filter).toUpperCase())) != null) {
            this.materials.add(material);
            return;
        }
        AbstractBlock block = MythicBukkit.inst().getBootstrap().getBlock((String)filter);
        if (!(block instanceof AbstractBlock.InvalidBlock)) {
            this.specificBlocks.add(block.getBlockData());
        }
        if (this.materials.isEmpty() && this.specificBlocks.isEmpty()) {
            MythicLogger.error("[BlockType] '" + (String)filter + "' is not a valid block type.");
        }
    }

    @Override
    public boolean matches(AbstractLocation location) {
        AbstractBlock block = location.getBlock();
        if (!this.materials.isEmpty() && this.materials.contains(block.getBlockData().getMaterial())) {
            return true;
        }
        if (!this.specificBlocks.isEmpty() && this.specificBlocks.contains(block.getBlockData())) {
            return true;
        }
        if (!this.tags.isEmpty()) {
            Material material = block.getBlockData().getMaterial();
            for (Tag<Material> tag : this.tags) {
                if (!tag.isTagged((Keyed)material)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean matches(Block block) {
        if (!this.materials.isEmpty() && this.materials.contains(block.getType())) {
            return true;
        }
        if (!this.specificBlocks.isEmpty() && this.specificBlocks.contains(block.getBlockData())) {
            return true;
        }
        if (!this.tags.isEmpty()) {
            Material material = block.getBlockData().getMaterial();
            for (Tag<Material> tag : this.tags) {
                if (!tag.isTagged((Keyed)material)) continue;
                return true;
            }
        }
        return false;
    }

    public Collection<Material> getMaterials() {
        return this.materials;
    }

    public Collection<BlockData> getSpecificBlocks() {
        return this.specificBlocks;
    }

    public Collection<Tag<Material>> getTags() {
        return this.tags;
    }
}

