/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.bukkit;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.promise.Promise;
import io.lumine.mythic.bukkit.utils.tasks.Task;
import io.lumine.mythic.bukkit.utils.terminable.Terminable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.java.JavaPlugin;

public class BukkitEntityLookup
implements Terminable {
    private static final long TTL_MILLIS = 300000L;
    private final ConcurrentMap<UUID, CacheEntry> cache = new ConcurrentHashMap<UUID, CacheEntry>();
    private final Task cleanupTask = Schedulers.sync().runRepeating(this::purgeStaleEntries, 6000L, 6000L);

    public BukkitEntityLookup(JavaPlugin plugin) {
    }

    @Override
    public void close() {
        this.cleanupTask.terminate();
        this.cache.clear();
    }

    public AbstractEntity getEntity(UUID uuid) {
        AbstractEntity loaded;
        if (uuid == null) {
            return null;
        }
        long now = System.currentTimeMillis();
        CacheEntry entry = (CacheEntry)this.cache.get(uuid);
        if (entry != null) {
            AbstractEntity e = (AbstractEntity)entry.ref.get();
            if (e != null && entry.expireAt > now) {
                return e;
            }
            this.cache.remove(uuid);
        }
        if ((loaded = this.loadEntity(uuid)) != null) {
            this.cache.put(uuid, new CacheEntry(loaded, now + 300000L));
        }
        return loaded;
    }

    public Collection<AbstractEntity> getEntities(Collection<UUID> uuids) {
        if (uuids.isEmpty()) {
            return Collections.emptyList();
        }
        long now = System.currentTimeMillis();
        ArrayList<AbstractEntity> result = new ArrayList<AbstractEntity>(uuids.size());
        if (Bukkit.isPrimaryThread()) {
            for (UUID uuid : uuids) {
                AbstractEntity ent = this.getCachedOrLoad(uuid, now);
                if (ent == null) continue;
                result.add(ent);
            }
        } else {
            try {
                Map rawMap = (Map)Promise.supplyingSync(() -> {
                    HashMap<UUID, Entity> m4 = new HashMap<UUID, Entity>();
                    for (UUID uuid : uuids) {
                        Entity be = Bukkit.getEntity((UUID)uuid);
                        if (be == null) continue;
                        m4.put(uuid, be);
                    }
                    return m4;
                }).get();
                for (Map.Entry e : rawMap.entrySet()) {
                    AbstractEntity ae = BukkitAdapter.adapt((Entity)e.getValue());
                    this.cache.put((UUID)e.getKey(), new CacheEntry(ae, now + 300000L));
                    result.add(ae);
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                for (UUID uuid : uuids) {
                    AbstractEntity ae = this.getEntity(uuid);
                    if (ae == null) continue;
                    result.add(ae);
                }
            }
        }
        return result;
    }

    private AbstractEntity getCachedOrLoad(UUID uuid, long now) {
        AbstractEntity loaded;
        CacheEntry entry = (CacheEntry)this.cache.get(uuid);
        if (entry != null) {
            AbstractEntity e = (AbstractEntity)entry.ref.get();
            if (e != null && entry.expireAt > now) {
                return e;
            }
            this.cache.remove(uuid);
        }
        if ((loaded = this.loadEntity(uuid)) != null) {
            this.cache.put(uuid, new CacheEntry(loaded, now + 300000L));
        }
        return loaded;
    }

    public void invalidate(UUID uuid) {
        this.cache.remove(uuid);
    }

    private void purgeStaleEntries() {
        long now = System.currentTimeMillis();
        Iterator it = this.cache.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry kv = it.next();
            CacheEntry e = (CacheEntry)kv.getValue();
            if (e.expireAt > now && e.ref.get() != null) continue;
            it.remove();
        }
    }

    private AbstractEntity loadEntity(UUID uuid) {
        try {
            Entity bukkitEntity = Bukkit.isPrimaryThread() ? Bukkit.getEntity((UUID)uuid) : (Entity)Promise.supplyingSync(() -> Bukkit.getEntity((UUID)uuid)).get();
            return bukkitEntity != null ? BukkitAdapter.adapt(bukkitEntity) : null;
        }
        catch (Throwable t2) {
            t2.printStackTrace();
            return null;
        }
    }

    private static class CacheEntry {
        final WeakReference<AbstractEntity> ref;
        final long expireAt;

        CacheEntry(AbstractEntity e, long expireAt) {
            this.ref = new WeakReference<AbstractEntity>(e);
            this.expireAt = expireAt;
        }
    }
}

