/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.adapters.items.components;

import io.lumine.mythic.api.adapters.AbstractItemComponent;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.core.items.MythicItem;
import io.lumine.mythic.core.logging.MythicLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;

public class AbstractItemToolComponent
implements AbstractItemComponent {
    private Integer damagePerBlock;
    private Float defaultMiningSpeed;
    private List<AbstractToolRule> rules = new ArrayList<AbstractToolRule>();

    public AbstractItemToolComponent(MythicItem mythicItem, MythicConfig config) {
        if (config.isSet("DamagePerBlock")) {
            this.damagePerBlock = config.getInt("DamagePerBlock");
        }
        if (config.isSet("DefaultMiningSpeed")) {
            this.defaultMiningSpeed = Float.valueOf(config.getFloat("DefaultMiningSpeed"));
            if (this.defaultMiningSpeed.floatValue() < 0.0f) {
                MythicLogger.errorGenericConfig(config, "DefaultMiningSpeed cannot be less than 0, using 1.0f instead");
                this.defaultMiningSpeed = Float.valueOf(1.0f);
            }
        }
        for (Map<?, ?> map : config.getMapList("Rules")) {
            String materialsString = (String)map.get("materials");
            double speed = map.containsKey("speed") ? (Double)map.get("speed") : 1.0;
            boolean isCorrectForBlock = map.containsKey("isCorrectForBlock") ? (Boolean)map.get("isCorrectForBlock") : false;
            String[] split = materialsString.split(",");
            if (split.length == 1) {
                Tag tag = Bukkit.getTag((String)"blocks", (NamespacedKey)NamespacedKey.minecraft((String)split[0].toLowerCase()), Material.class);
                if (tag != null) {
                    this.rules.add(new AbstractToolRule(null, (Tag<Material>)tag, Float.valueOf((float)speed), isCorrectForBlock));
                    continue;
                }
                Material material = Material.getMaterial((String)split[0].toUpperCase());
                if (material != null) {
                    this.rules.add(new AbstractToolRule(List.of(material), null, Float.valueOf((float)speed), isCorrectForBlock));
                    continue;
                }
                MythicLogger.errorGenericConfig(config, "Material " + split[0] + " is not a valid material");
            }
            ArrayList<Material> materials = new ArrayList<Material>();
            for (String materialString : split) {
                Material material = Material.getMaterial((String)(materialString = materialString.toUpperCase()));
                if (material != null) {
                    materials.add(material);
                    continue;
                }
                MythicLogger.errorGenericConfig(config, "Material " + materialString + " is not a valid material");
            }
            this.rules.add(new AbstractToolRule(materials, null, Float.valueOf((float)speed), isCorrectForBlock));
        }
    }

    @Override
    public void apply(MythicItem mythicItem, DropMetadata dropMetadata, AbstractItemStack itemStack) {
        itemStack.applyToolComponent(this);
    }

    public Integer getDamagePerBlock() {
        return this.damagePerBlock;
    }

    public Float getDefaultMiningSpeed() {
        return this.defaultMiningSpeed;
    }

    public List<AbstractToolRule> getRules() {
        return this.rules;
    }

    public void setDamagePerBlock(Integer damagePerBlock) {
        this.damagePerBlock = damagePerBlock;
    }

    public void setDefaultMiningSpeed(Float defaultMiningSpeed) {
        this.defaultMiningSpeed = defaultMiningSpeed;
    }

    public void setRules(List<AbstractToolRule> rules) {
        this.rules = rules;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractItemToolComponent)) {
            return false;
        }
        AbstractItemToolComponent other = (AbstractItemToolComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$damagePerBlock = this.getDamagePerBlock();
        Integer other$damagePerBlock = other.getDamagePerBlock();
        if (this$damagePerBlock == null ? other$damagePerBlock != null : !((Object)this$damagePerBlock).equals(other$damagePerBlock)) {
            return false;
        }
        Float this$defaultMiningSpeed = this.getDefaultMiningSpeed();
        Float other$defaultMiningSpeed = other.getDefaultMiningSpeed();
        if (this$defaultMiningSpeed == null ? other$defaultMiningSpeed != null : !((Object)this$defaultMiningSpeed).equals(other$defaultMiningSpeed)) {
            return false;
        }
        List<AbstractToolRule> this$rules = this.getRules();
        List<AbstractToolRule> other$rules = other.getRules();
        return !(this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractItemToolComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $damagePerBlock = this.getDamagePerBlock();
        result = result * 59 + ($damagePerBlock == null ? 43 : ((Object)$damagePerBlock).hashCode());
        Float $defaultMiningSpeed = this.getDefaultMiningSpeed();
        result = result * 59 + ($defaultMiningSpeed == null ? 43 : ((Object)$defaultMiningSpeed).hashCode());
        List<AbstractToolRule> $rules = this.getRules();
        result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
        return result;
    }

    public String toString() {
        return "AbstractItemToolComponent(damagePerBlock=" + this.getDamagePerBlock() + ", defaultMiningSpeed=" + this.getDefaultMiningSpeed() + ", rules=" + String.valueOf(this.getRules()) + ")";
    }

    public class AbstractToolRule {
        private List<Material> materials;
        private Tag<Material> tag;
        private Float speed;
        private Boolean isCorrectForBlock;

        public List<Material> getMaterials() {
            return this.materials;
        }

        public Tag<Material> getTag() {
            return this.tag;
        }

        public Float getSpeed() {
            return this.speed;
        }

        public Boolean getIsCorrectForBlock() {
            return this.isCorrectForBlock;
        }

        public void setMaterials(List<Material> materials) {
            this.materials = materials;
        }

        public void setTag(Tag<Material> tag) {
            this.tag = tag;
        }

        public void setSpeed(Float speed) {
            this.speed = speed;
        }

        public void setIsCorrectForBlock(Boolean isCorrectForBlock) {
            this.isCorrectForBlock = isCorrectForBlock;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AbstractToolRule)) {
                return false;
            }
            AbstractToolRule other = (AbstractToolRule)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Float this$speed = this.getSpeed();
            Float other$speed = other.getSpeed();
            if (this$speed == null ? other$speed != null : !((Object)this$speed).equals(other$speed)) {
                return false;
            }
            Boolean this$isCorrectForBlock = this.getIsCorrectForBlock();
            Boolean other$isCorrectForBlock = other.getIsCorrectForBlock();
            if (this$isCorrectForBlock == null ? other$isCorrectForBlock != null : !((Object)this$isCorrectForBlock).equals(other$isCorrectForBlock)) {
                return false;
            }
            List<Material> this$materials = this.getMaterials();
            List<Material> other$materials = other.getMaterials();
            if (this$materials == null ? other$materials != null : !((Object)this$materials).equals(other$materials)) {
                return false;
            }
            Tag<Material> this$tag = this.getTag();
            Tag<Material> other$tag = other.getTag();
            return !(this$tag == null ? other$tag != null : !this$tag.equals(other$tag));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AbstractToolRule;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Float $speed = this.getSpeed();
            result = result * 59 + ($speed == null ? 43 : ((Object)$speed).hashCode());
            Boolean $isCorrectForBlock = this.getIsCorrectForBlock();
            result = result * 59 + ($isCorrectForBlock == null ? 43 : ((Object)$isCorrectForBlock).hashCode());
            List<Material> $materials = this.getMaterials();
            result = result * 59 + ($materials == null ? 43 : ((Object)$materials).hashCode());
            Tag<Material> $tag = this.getTag();
            result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
            return result;
        }

        public String toString() {
            return "AbstractItemToolComponent.AbstractToolRule(materials=" + String.valueOf(this.getMaterials()) + ", tag=" + String.valueOf(this.getTag()) + ", speed=" + this.getSpeed() + ", isCorrectForBlock=" + this.getIsCorrectForBlock() + ")";
        }

        public AbstractToolRule(List<Material> materials, Tag<Material> tag, Float speed, Boolean isCorrectForBlock) {
            this.materials = materials;
            this.tag = tag;
            this.speed = speed;
            this.isCorrectForBlock = isCorrectForBlock;
        }
    }
}

