/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.api.adapters.items.components;

import io.lumine.mythic.api.adapters.AbstractItemComponent;
import io.lumine.mythic.api.adapters.AbstractItemStack;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderColor;
import io.lumine.mythic.core.items.MythicItem;
import java.util.Collection;

public class AbstractItemBannerComponent
implements AbstractItemComponent {
    private PlaceholderColor color;
    private Collection<String> bannerLayers;

    public AbstractItemBannerComponent(MythicItem item, MythicConfig config) {
        this.color = config.getPlaceholderColor("Color", null);
        this.bannerLayers = config.getStringList("BannerLayers");
    }

    @Override
    public void apply(MythicItem mythicItem, DropMetadata dropMetadata, AbstractItemStack itemStack) {
        itemStack.applyBannerComponent(dropMetadata, this);
    }

    public PlaceholderColor getColor() {
        return this.color;
    }

    public Collection<String> getBannerLayers() {
        return this.bannerLayers;
    }

    public void setColor(PlaceholderColor color) {
        this.color = color;
    }

    public void setBannerLayers(Collection<String> bannerLayers) {
        this.bannerLayers = bannerLayers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractItemBannerComponent)) {
            return false;
        }
        AbstractItemBannerComponent other = (AbstractItemBannerComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PlaceholderColor this$color = this.getColor();
        PlaceholderColor other$color = other.getColor();
        if (this$color == null ? other$color != null : !this$color.equals(other$color)) {
            return false;
        }
        Collection<String> this$bannerLayers = this.getBannerLayers();
        Collection<String> other$bannerLayers = other.getBannerLayers();
        return !(this$bannerLayers == null ? other$bannerLayers != null : !((Object)this$bannerLayers).equals(other$bannerLayers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractItemBannerComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PlaceholderColor $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : $color.hashCode());
        Collection<String> $bannerLayers = this.getBannerLayers();
        result = result * 59 + ($bannerLayers == null ? 43 : ((Object)$bannerLayers).hashCode());
        return result;
    }

    public String toString() {
        return "AbstractItemBannerComponent(color=" + String.valueOf(this.getColor()) + ", bannerLayers=" + String.valueOf(this.getBannerLayers()) + ")";
    }
}

