/*
 * Decompiled with CFR 0.152.
 */
package com.roklenarcic.util.strings;

import com.roklenarcic.util.strings.MapMatchListener;
import com.roklenarcic.util.strings.Queue;
import com.roklenarcic.util.strings.ReadableMatchListener;
import com.roklenarcic.util.strings.StringMap;
import com.roklenarcic.util.strings.WordCharacters;
import com.roklenarcic.util.strings.threshold.RangeNodeThreshold;
import com.roklenarcic.util.strings.threshold.Thresholder;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.Iterator;

public class WholeWordLongestMatchMap<T>
implements StringMap<T> {
    private boolean caseSensitive = true;
    private int charBufferSize = 0;
    private TrieNode<T> root;
    private boolean[] wordChars;

    public WholeWordLongestMatchMap(Iterable<String> keywords, Iterable<? extends T> values, boolean caseSensitive) {
        this(keywords, values, caseSensitive, new RangeNodeThreshold());
    }

    public WholeWordLongestMatchMap(Iterable<String> keywords, Iterable<? extends T> values, boolean caseSensitive, char[] wordCharacters) {
        this(keywords, values, caseSensitive, wordCharacters, new RangeNodeThreshold());
    }

    public WholeWordLongestMatchMap(Iterable<String> keywords, Iterable<? extends T> values, boolean caseSensitive, char[] wordCharacters, boolean[] toggleFlags) {
        this(keywords, values, caseSensitive, wordCharacters, toggleFlags, new RangeNodeThreshold());
    }

    public WholeWordLongestMatchMap(Iterable<String> keywords, Iterable<? extends T> values, boolean caseSensitive, char[] wordCharacters, boolean[] toggleFlags, Thresholder thresholdStrategy) {
        this.init(keywords, values, caseSensitive, WordCharacters.generateWordCharsFlags(wordCharacters, toggleFlags), thresholdStrategy);
    }

    public WholeWordLongestMatchMap(Iterable<String> keywords, Iterable<? extends T> values, boolean caseSensitive, char[] wordCharacters, Thresholder thresholdStrategy) {
        this.init(keywords, values, caseSensitive, WordCharacters.generateWordCharsFlags(wordCharacters), thresholdStrategy);
    }

    public WholeWordLongestMatchMap(Iterable<String> keywords, Iterable<? extends T> values, boolean caseSensitive, Thresholder thresholdStrategy) {
        this.init(keywords, values, caseSensitive, WordCharacters.generateWordCharsFlags(), thresholdStrategy);
    }

    @Override
    public void match(Readable haystack, ReadableMatchListener<T> listener) throws IOException {
        TrieNode<T> currentNode = this.root;
        CharBuffer buf = CharBuffer.allocate(this.charBufferSize);
        if (this.caseSensitive) {
            block0: while (haystack.read(buf) != -1) {
                buf.flip();
                while (buf.hasRemaining()) {
                    char c = buf.get();
                    TrieNode<T> nextNode = currentNode.getTransition(c);
                    if (nextNode == null) {
                        if (!this.wordChars[c]) {
                            if (currentNode.matchLength != 0 ? !listener.match(currentNode.value) : currentNode.failMatchLength != 0 && !listener.match(currentNode.failValue)) {
                                return;
                            }
                        } else {
                            if (currentNode.failMatchLength != 0 && !listener.match(currentNode.failValue)) {
                                return;
                            }
                            if (this.scroll(haystack, buf, true, true)) {
                                currentNode = this.root;
                                break block0;
                            }
                        }
                        currentNode = this.root;
                        if (!this.scroll(haystack, buf, false, true)) continue;
                        break block0;
                    }
                    currentNode = nextNode;
                }
                buf.clear();
            }
            if (currentNode.matchLength != 0) {
                listener.match(currentNode.value);
            } else if (currentNode.failMatchLength != 0) {
                listener.match(currentNode.failValue);
            }
        } else {
            block2: while (haystack.read(buf) != -1) {
                buf.flip();
                while (buf.hasRemaining()) {
                    char c = Character.toLowerCase(buf.get());
                    TrieNode<T> nextNode = currentNode.getTransition(c);
                    if (nextNode == null) {
                        if (!this.wordChars[c]) {
                            if (currentNode.matchLength != 0 ? !listener.match(currentNode.value) : currentNode.failMatchLength != 0 && !listener.match(currentNode.failValue)) {
                                return;
                            }
                        } else {
                            if (currentNode.failMatchLength != 0 && !listener.match(currentNode.failValue)) {
                                return;
                            }
                            if (this.scroll(haystack, buf, true, false)) {
                                currentNode = this.root;
                                break block2;
                            }
                        }
                        currentNode = this.root;
                        if (!this.scroll(haystack, buf, false, false)) continue;
                        break block2;
                    }
                    currentNode = nextNode;
                }
                buf.clear();
            }
            if (currentNode.matchLength != 0) {
                listener.match(currentNode.value);
            } else if (currentNode.failMatchLength != 0) {
                listener.match(currentNode.failValue);
            }
        }
    }

    @Override
    public void match(String haystack, MapMatchListener<T> listener) {
        TrieNode<T> currentNode = this.root;
        int idx = 0;
        int len = haystack.length();
        if (this.caseSensitive) {
            while (idx < len) {
                char c = haystack.charAt(idx);
                TrieNode<T> nextNode = currentNode.getTransition(c);
                if (nextNode == null) {
                    int failMatchEnd;
                    if (!this.wordChars[c]) {
                        if (currentNode.matchLength != 0 ? !listener.match(haystack, idx - currentNode.matchLength, idx, currentNode.value) : currentNode.failMatchLength != 0 && !listener.match(haystack, (failMatchEnd = idx - currentNode.failMatchOffset) - currentNode.failMatchLength, failMatchEnd, currentNode.failValue)) {
                            return;
                        }
                    } else {
                        if (currentNode.failMatchLength != 0 && !listener.match(haystack, (failMatchEnd = idx - currentNode.failMatchOffset) - currentNode.failMatchLength, failMatchEnd, currentNode.failValue)) {
                            return;
                        }
                        while (++idx < len && this.wordChars[haystack.charAt(idx)]) {
                        }
                    }
                    while (++idx < len && !this.wordChars[haystack.charAt(idx)]) {
                    }
                    currentNode = this.root;
                    continue;
                }
                ++idx;
                currentNode = nextNode;
            }
            if (currentNode.matchLength != 0) {
                listener.match(haystack, idx - currentNode.matchLength, idx, currentNode.value);
            } else if (currentNode.failMatchLength != 0) {
                int failMatchEnd = idx - currentNode.failMatchOffset;
                listener.match(haystack, failMatchEnd - currentNode.failMatchLength, failMatchEnd, currentNode.failValue);
            }
        } else {
            while (idx < len) {
                char c = Character.toLowerCase(haystack.charAt(idx));
                TrieNode<T> nextNode = currentNode.getTransition(c);
                if (nextNode == null) {
                    int failMatchEnd;
                    if (!this.wordChars[c]) {
                        if (currentNode.matchLength != 0 ? !listener.match(haystack, idx - currentNode.matchLength, idx, currentNode.value) : currentNode.failMatchLength != 0 && !listener.match(haystack, (failMatchEnd = idx - currentNode.failMatchOffset) - currentNode.failMatchLength, failMatchEnd, currentNode.failValue)) {
                            return;
                        }
                    } else {
                        if (currentNode.failMatchLength != 0 && !listener.match(haystack, (failMatchEnd = idx - currentNode.failMatchOffset) - currentNode.failMatchLength, failMatchEnd, currentNode.failValue)) {
                            return;
                        }
                        while (++idx < len && this.wordChars[Character.toLowerCase(haystack.charAt(idx))]) {
                        }
                    }
                    while (++idx < len && !this.wordChars[Character.toLowerCase(haystack.charAt(idx))]) {
                    }
                    currentNode = this.root;
                    continue;
                }
                ++idx;
                currentNode = nextNode;
            }
            if (currentNode.matchLength != 0) {
                listener.match(haystack, idx - currentNode.matchLength, idx, currentNode.value);
            } else if (currentNode.failMatchLength != 0) {
                int failMatchEnd = idx - currentNode.failMatchOffset;
                listener.match(haystack, failMatchEnd - currentNode.failMatchLength, failMatchEnd, currentNode.failValue);
            }
        }
    }

    boolean[] getWordChars() {
        return this.wordChars;
    }

    private void init(Iterable<String> keywords, Iterable<? extends T> values, boolean caseSensitive, final boolean[] wordChars, final Thresholder thresholdStrategy) {
        this.caseSensitive = caseSensitive;
        Iterator<String> keywordsIter = keywords.iterator();
        Iterator<T> valuesIter = values.iterator();
        this.wordChars = wordChars;
        int longestKeyword = 0;
        this.root = new HashmapNode();
        while (keywordsIter.hasNext() && valuesIter.hasNext()) {
            String keyword = keywordsIter.next();
            T value = valuesIter.next();
            if (keyword == null || (keyword = WordCharacters.trim(keyword, wordChars)).length() <= 0) continue;
            if (keyword.length() > longestKeyword) {
                longestKeyword = keyword.length();
            }
            HashmapNode currentNode = (HashmapNode)this.root;
            for (int idx = 0; idx < keyword.length(); ++idx) {
                currentNode = currentNode.getOrAddChild(caseSensitive ? keyword.charAt(idx) : Character.toLowerCase(keyword.charAt(idx)));
            }
            currentNode.matchLength = keyword.length();
            currentNode.value = value;
        }
        this.charBufferSize = longestKeyword > 2048 ? longestKeyword * 2 : 4096;
        final Queue<TrieNode<T>> queue = new Queue<TrieNode<T>>();
        this.root = this.root.optimizeNode(0, thresholdStrategy);
        queue.push(this.root);
        queue.push(null);
        final int[] level = new int[]{1};
        EntryVisitor optimizeNodesAndFailTransitions = new EntryVisitor<T>(){

            @Override
            public void visit(TrieNode<T> parent, char key, TrieNode<T> value) {
                value = value.optimizeNode(level[0], thresholdStrategy);
                parent.updateTransition(key, value);
                if (parent.matchLength != 0 && !wordChars[key]) {
                    value.failMatchLength = parent.matchLength;
                    value.failMatchOffset = 1;
                    value.failValue = parent.value;
                } else {
                    value.failMatchLength = parent.failMatchLength;
                    value.failMatchOffset = parent.failMatchOffset + 1;
                    value.failValue = parent.failValue;
                }
                if (!value.isEmpty()) {
                    queue.push(value);
                }
            }
        };
        while (!queue.isEmpty()) {
            TrieNode n = (TrieNode)queue.take();
            if (n == null) {
                if (queue.isEmpty()) continue;
                queue.push(null);
                level[0] = level[0] + 1;
                continue;
            }
            n.mapEntries(optimizeNodesAndFailTransitions);
        }
    }

    private boolean scroll(Readable haystack, CharBuffer buf, boolean wordChars, boolean caseSensitive) throws IOException {
        while (true) {
            if (buf.hasRemaining()) {
                if (this.wordChars[caseSensitive ? buf.get() : Character.toLowerCase(buf.get())] == wordChars) continue;
                buf.position(buf.position() - 1);
                return false;
            }
            buf.clear();
            if (haystack.read(buf) == -1) {
                return true;
            }
            buf.flip();
        }
    }

    private static abstract class TrieNode<T> {
        protected int failMatchLength = 0;
        protected int failMatchOffset = 0;
        protected T failValue;
        protected int matchLength = 0;
        protected T value;

        private TrieNode() {
        }

        public abstract void clear();

        public abstract TrieNode<T> getTransition(char var1);

        public abstract boolean isEmpty();

        public abstract void mapEntries(EntryVisitor<T> var1);

        public abstract void updateTransition(char var1, TrieNode<T> var2);

        protected TrieNode<T> optimizeNode(int level, Thresholder thresholdStrategy) {
            return this;
        }
    }

    private static final class RangeNode<T>
    extends TrieNode<T> {
        private char baseChar = '\u0000';
        private TrieNode<T>[] children;
        private int size = 0;

        private RangeNode(HashmapNode<T> oldNode, char from, char to) {
            this.baseChar = from;
            this.size = to - from + 1;
            this.matchLength = oldNode.matchLength;
            this.value = oldNode.value;
            if (this.size <= 0) {
                this.size = 0;
            } else {
                this.children = new TrieNode[this.size];
                for (int i = 0; i < ((HashmapNode)oldNode).children.length; ++i) {
                    if (((HashmapNode)oldNode).children[i] == null) continue;
                    this.children[((HashmapNode)oldNode).keys[i] - from] = ((HashmapNode)oldNode).children[i];
                }
            }
        }

        @Override
        public void clear() {
            this.children = null;
            this.size = 0;
        }

        @Override
        public TrieNode<T> getTransition(char c) {
            char idx = (char)(c - this.baseChar);
            if (idx < this.size) {
                return this.children[idx];
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public void mapEntries(EntryVisitor<T> visitor) {
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    if (this.children[i] == null || this.children[i] == this) continue;
                    visitor.visit(this, (char)(this.baseChar + i), this.children[i]);
                }
            }
        }

        @Override
        public void updateTransition(char c, TrieNode<T> node) {
            char idx = (char)(c - this.baseChar);
            if (idx < this.size) {
                if (this.children[idx] != null) {
                    this.children[idx] = node;
                    return;
                }
                throw new IllegalArgumentException("Transition for " + c + " doesn't exist.");
            }
            throw new IllegalArgumentException("Transition for " + c + " doesn't exist.");
        }
    }

    private static final class HashmapNode<T>
    extends TrieNode<T> {
        private TrieNode<T>[] children = new TrieNode[1];
        private char[] keys = new char[1];
        private int modulusMask = this.keys.length - 1;
        private int numEntries = 0;

        private HashmapNode() {
        }

        @Override
        public void clear() {
            this.children = new TrieNode[1];
            this.keys = new char[1];
            this.modulusMask = this.keys.length - 1;
            this.numEntries = 0;
        }

        @Override
        public TrieNode<T> getTransition(char key) {
            int defaultSlot;
            int currentSlot = defaultSlot = this.hash(key) & this.modulusMask;
            do {
                if (this.keys[currentSlot] == key) {
                    return this.children[currentSlot];
                }
                if (this.children[currentSlot] == null) {
                    return null;
                }
                ++currentSlot;
            } while ((currentSlot &= this.modulusMask) != defaultSlot);
            return null;
        }

        @Override
        public boolean isEmpty() {
            return this.numEntries == 0;
        }

        @Override
        public void mapEntries(EntryVisitor<T> visitor) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (this.children[i] == null) continue;
                visitor.visit(this, this.keys[i], this.children[i]);
            }
        }

        @Override
        public void updateTransition(char c, TrieNode<T> node) {
            int defaultSlot;
            int currentSlot = defaultSlot = this.hash(c) & this.modulusMask;
            do {
                if (this.children[currentSlot] == null) {
                    throw new IllegalArgumentException("Transition for " + c + " doesn't exist.");
                }
                if (this.keys[currentSlot] == c) {
                    this.children[currentSlot] = node;
                    return;
                }
                ++currentSlot;
            } while ((currentSlot &= this.modulusMask) != defaultSlot);
            throw new IllegalArgumentException("Transition for " + c + " doesn't exist.");
        }

        @Override
        protected TrieNode<T> optimizeNode(int level, Thresholder thresholdStrategy) {
            char minKey = '\uffff';
            char maxKey = '\u0000';
            int size = this.numEntries;
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i] == null) continue;
                if (this.keys[i] > maxKey) {
                    maxKey = this.keys[i];
                }
                if (this.keys[i] >= minKey) continue;
                minKey = this.keys[i];
            }
            int keyIntervalSize = maxKey - minKey + 1;
            if (thresholdStrategy.isOverThreshold(size, level, keyIntervalSize)) {
                return new RangeNode(this, minKey, maxKey);
            }
            return this;
        }

        private void enlarge() {
            char[] biggerKeys = new char[this.keys.length * 2];
            TrieNode[] biggerChildren = new TrieNode[this.children.length * 2];
            int biggerMask = biggerKeys.length - 1;
            block0: for (int i = 0; i < this.children.length; ++i) {
                int defaultSlot;
                char key = this.keys[i];
                TrieNode<T> node = this.children[i];
                if (node == null) continue;
                int currentSlot = defaultSlot = this.hash(key) & biggerMask;
                do {
                    if (biggerChildren[currentSlot] == null) {
                        biggerKeys[currentSlot] = key;
                        biggerChildren[currentSlot] = node;
                        continue block0;
                    }
                    if (biggerKeys[currentSlot] == key) {
                        throw new IllegalStateException();
                    }
                    ++currentSlot;
                } while ((currentSlot &= biggerMask) != defaultSlot);
            }
            this.keys = biggerKeys;
            this.children = biggerChildren;
            this.modulusMask = biggerMask;
        }

        private HashmapNode<T> getOrAddChild(char key) {
            int defaultSlot;
            if (this.keys.length < 65536 && (this.numEntries >= this.keys.length || this.numEntries > 16 && (float)this.numEntries >= (float)this.keys.length * 0.9f)) {
                this.enlarge();
            }
            int currentSlot = defaultSlot = this.hash(key) & this.modulusMask;
            do {
                if (this.children[currentSlot] == null) {
                    this.keys[currentSlot] = key;
                    HashmapNode<T> newChild = new HashmapNode<T>();
                    this.children[currentSlot] = newChild;
                    ++this.numEntries;
                    return newChild;
                }
                if (this.keys[currentSlot] == key) {
                    return (HashmapNode)this.children[currentSlot];
                }
                ++currentSlot;
            } while ((currentSlot &= this.modulusMask) != defaultSlot);
            throw new IllegalStateException();
        }

        private int hash(char c) {
            int HASH_PRIME = 16777619;
            return ((0x811C9DC5 ^ c >> 8) * 16777619 ^ c & 0xFF) * 16777619;
        }
    }

    private static interface EntryVisitor<T> {
        public void visit(TrieNode<T> var1, char var2, TrieNode<T> var3);
    }
}

