/*
 * Decompiled with CFR 0.152.
 */
package com.roklenarcic.util.strings;

import com.roklenarcic.util.strings.MapMatchListener;
import com.roklenarcic.util.strings.Queue;
import com.roklenarcic.util.strings.ReadableMatchListener;
import com.roklenarcic.util.strings.StringMap;
import com.roklenarcic.util.strings.threshold.RangeNodeThreshold;
import com.roklenarcic.util.strings.threshold.Thresholder;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Iterator;

public class AhoCorasickMap<T>
implements StringMap<T> {
    private boolean caseSensitive = true;
    private int charBufferSize = 0;
    private TrieNode<T> root;

    public AhoCorasickMap(Iterable<String> keywords, Iterable<? extends T> values, boolean caseSensitive) {
        this(keywords, values, caseSensitive, new RangeNodeThreshold());
    }

    public AhoCorasickMap(Iterable<String> keywords, Iterable<? extends T> values, boolean caseSensitive, final Thresholder thresholdStrategy) {
        Iterator<String> keywordsIter = keywords.iterator();
        Iterator<T> valuesIter = values.iterator();
        this.caseSensitive = caseSensitive;
        this.root = new HashmapNode(true);
        int longestKeyword = 0;
        while (keywordsIter.hasNext() && valuesIter.hasNext()) {
            String keyword = keywordsIter.next();
            T value = valuesIter.next();
            if (keyword == null || keyword.length() <= 0) continue;
            if (keyword.length() > longestKeyword) {
                longestKeyword = keyword.length();
            }
            HashmapNode currentNode = (HashmapNode)this.root;
            for (int idx = 0; idx < keyword.length(); ++idx) {
                currentNode = currentNode.getOrAddChild(caseSensitive ? keyword.charAt(idx) : Character.toLowerCase(keyword.charAt(idx)));
            }
            currentNode.matchLength = keyword.length();
            currentNode.value = value;
        }
        this.charBufferSize = longestKeyword > 2048 ? longestKeyword * 2 : 4096;
        final Queue<TrieNode<T>> queue = new Queue<TrieNode<T>>();
        this.root = this.root.optimizeNode(0, thresholdStrategy);
        queue.push(this.root);
        queue.push(null);
        final int[] level = new int[]{1};
        EntryVisitor failTransAndOutputsVisitor = new EntryVisitor<T>(){

            @Override
            public void visit(TrieNode<T> parent, char key, TrieNode<T> value) {
                value = value.optimizeNode(level[0], thresholdStrategy);
                parent.updateTransition(key, value);
                TrieNode parentFail = parent.getFailTransition();
                if (parentFail == null) {
                    value.failTransition = parent;
                } else {
                    do {
                        TrieNode matchContinuation;
                        if ((matchContinuation = parentFail.getTransition(key)) != null) {
                            value.failTransition = matchContinuation;
                            continue;
                        }
                        parentFail = parentFail.getFailTransition();
                    } while (value.failTransition == null);
                    TrieNode fail = value.failTransition;
                    while (fail != AhoCorasickMap.this.root && fail.matchLength == 0) {
                        fail = fail.failTransition;
                    }
                    if (fail.matchLength > 0) {
                        if (value.matchLength == 0) {
                            value.matchLength = fail.matchLength;
                            value.suffixMatch = fail.suffixMatch;
                            value.value = fail.value;
                        } else {
                            value.suffixMatch = fail;
                        }
                    }
                }
                if (!value.isEmpty()) {
                    queue.push(value);
                }
            }
        };
        while (!queue.isEmpty()) {
            TrieNode n = (TrieNode)queue.take();
            if (n == null) {
                if (queue.isEmpty()) continue;
                queue.push(null);
                level[0] = level[0] + 1;
                continue;
            }
            n.mapEntries(failTransAndOutputsVisitor);
        }
        EntryVisitor enqueueNodesVisitor = new EntryVisitor<T>(){

            @Override
            public void visit(TrieNode<T> parent, char key, TrieNode<T> value) {
                if (!value.isEmpty()) {
                    queue.push(value);
                }
            }
        };
        this.root.mapEntries(enqueueNodesVisitor);
        while (!queue.isEmpty()) {
            TrieNode node = (TrieNode)queue.pop();
            if (node == null) {
                node = (TrieNode)queue.pop();
                if (!(node instanceof RangeNode)) continue;
                RangeNode rangeNode = (RangeNode)node;
                block4: for (int i = 0; i < rangeNode.size; ++i) {
                    if (rangeNode.children[i] != null) continue;
                    char charOfMissingTransition = (char)(rangeNode.baseChar + i);
                    TrieNode n = rangeNode.failTransition;
                    while (n != null) {
                        TrieNode nextNode = n.getTransition(charOfMissingTransition);
                        if (nextNode == null) {
                            n = n.failTransition;
                            continue;
                        }
                        ((RangeNode)rangeNode).children[i] = nextNode;
                        continue block4;
                    }
                }
                continue;
            }
            queue.push(null);
            node.mapEntries(enqueueNodesVisitor);
        }
    }

    @Override
    public void match(Readable haystack, ReadableMatchListener<T> listener) throws IOException {
        TrieNode<T> currentNode = this.root;
        CharBuffer buf = CharBuffer.allocate(this.charBufferSize);
        if (this.caseSensitive) {
            while (haystack.read(buf) != -1) {
                buf.flip();
                while (buf.hasRemaining()) {
                    char c = buf.get();
                    TrieNode<T> nextNode = currentNode.getTransition(c);
                    while (nextNode == null) {
                        currentNode = currentNode.getFailTransition();
                        nextNode = currentNode.getTransition(c);
                    }
                    currentNode = nextNode;
                    if (currentNode.output(listener)) continue;
                    return;
                }
                buf.clear();
            }
        } else {
            while (haystack.read(buf) != -1) {
                buf.flip();
                while (buf.hasRemaining()) {
                    char c = Character.toLowerCase(buf.get());
                    TrieNode<T> nextNode = currentNode.getTransition(c);
                    while (nextNode == null) {
                        currentNode = currentNode.getFailTransition();
                        nextNode = currentNode.getTransition(c);
                    }
                    currentNode = nextNode;
                    if (currentNode.output(listener)) continue;
                    return;
                }
                buf.clear();
            }
        }
    }

    @Override
    public void match(String haystack, MapMatchListener<T> listener) {
        TrieNode<T> currentNode = this.root;
        int idx = 0;
        int len = haystack.length();
        if (this.caseSensitive) {
            while (idx < len) {
                char c = haystack.charAt(idx);
                TrieNode<T> nextNode = currentNode.getTransition(c);
                while (nextNode == null) {
                    currentNode = currentNode.getFailTransition();
                    nextNode = currentNode.getTransition(c);
                }
                currentNode = nextNode;
                if (currentNode.output(haystack, listener, ++idx)) continue;
                break;
            }
        } else {
            while (idx < len) {
                char c = Character.toLowerCase(haystack.charAt(idx));
                TrieNode<T> nextNode = currentNode.getTransition(c);
                while (nextNode == null) {
                    currentNode = currentNode.getFailTransition();
                    nextNode = currentNode.getTransition(c);
                }
                currentNode = nextNode;
                if (currentNode.output(haystack, listener, ++idx)) continue;
                break;
            }
        }
    }

    private static abstract class TrieNode<T> {
        protected TrieNode<T> defaultTransition = null;
        protected TrieNode<T> failTransition;
        protected int matchLength = 0;
        protected TrieNode<T> suffixMatch;
        protected T value = null;

        protected TrieNode(boolean root) {
            this.defaultTransition = root ? this : null;
        }

        public final TrieNode<T> getFailTransition() {
            return this.failTransition;
        }

        public abstract TrieNode<T> getTransition(char var1);

        public abstract boolean isEmpty();

        public abstract void mapEntries(EntryVisitor<T> var1);

        public final boolean output(ReadableMatchListener<T> listener) {
            boolean ret = true;
            if (this.matchLength > 0) {
                ret = listener.match(this.value);
                TrieNode<T> suffixMatch = this.suffixMatch;
                while (suffixMatch != null && ret) {
                    ret = listener.match(suffixMatch.value);
                    suffixMatch = suffixMatch.suffixMatch;
                }
            }
            return ret;
        }

        public final boolean output(String haystack, MapMatchListener<T> listener, int idx) {
            boolean ret = true;
            if (this.matchLength > 0) {
                ret = listener.match(haystack, idx - this.matchLength, idx, this.value);
                TrieNode<T> suffixMatch = this.suffixMatch;
                while (suffixMatch != null && ret) {
                    ret = listener.match(haystack, idx - suffixMatch.matchLength, idx, suffixMatch.value);
                    suffixMatch = suffixMatch.suffixMatch;
                }
            }
            return ret;
        }

        public abstract void updateTransition(char var1, TrieNode<T> var2);

        protected TrieNode<T> optimizeNode(int level, Thresholder thresholdStrategy) {
            return this;
        }
    }

    private static final class RangeNode<T>
    extends TrieNode<T> {
        private char baseChar = '\u0000';
        private TrieNode<T>[] children;
        private int size = 0;

        private RangeNode(HashmapNode<T> oldNode, char from, char to) {
            super(oldNode.defaultTransition != null);
            this.baseChar = from;
            this.value = oldNode.value;
            this.size = to - from + 1;
            this.matchLength = oldNode.matchLength;
            if (this.size <= 0) {
                this.size = 0;
            } else {
                this.children = new TrieNode[this.size];
                if (oldNode.defaultTransition != null) {
                    Arrays.fill(this.children, this);
                }
                for (int i = 0; i < ((HashmapNode)oldNode).children.length; ++i) {
                    if (((HashmapNode)oldNode).children[i] == null) continue;
                    this.children[((HashmapNode)oldNode).keys[i] - from] = ((HashmapNode)oldNode).children[i];
                }
            }
        }

        @Override
        public TrieNode<T> getTransition(char c) {
            char idx = (char)(c - this.baseChar);
            if (idx < this.size) {
                return this.children[idx];
            }
            return this.defaultTransition;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public void mapEntries(EntryVisitor<T> visitor) {
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    if (this.children[i] == null || this.children[i] == this) continue;
                    visitor.visit(this, (char)(this.baseChar + i), this.children[i]);
                }
            }
        }

        @Override
        public void updateTransition(char c, TrieNode<T> node) {
            char idx = (char)(c - this.baseChar);
            if (idx < this.size) {
                if (this.children[idx] != null) {
                    this.children[idx] = node;
                    return;
                }
                throw new IllegalArgumentException("Transition for " + c + " doesn't exist.");
            }
            throw new IllegalArgumentException("Transition for " + c + " doesn't exist.");
        }
    }

    private static final class HashmapNode<T>
    extends TrieNode<T> {
        private TrieNode<T>[] children = new TrieNode[1];
        private char[] keys = new char[1];
        private int modulusMask = this.keys.length - 1;
        private int numEntries = 0;

        protected HashmapNode(boolean root) {
            super(root);
        }

        @Override
        public TrieNode<T> getTransition(char key) {
            int defaultSlot;
            int currentSlot = defaultSlot = this.hash(key) & this.modulusMask;
            do {
                if (this.keys[currentSlot] == key) {
                    return this.children[currentSlot];
                }
                if (this.children[currentSlot] == null) {
                    return this.defaultTransition;
                }
                ++currentSlot;
            } while ((currentSlot &= this.modulusMask) != defaultSlot);
            return this.defaultTransition;
        }

        @Override
        public boolean isEmpty() {
            return this.numEntries == 0;
        }

        @Override
        public void mapEntries(EntryVisitor<T> visitor) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (this.children[i] == null) continue;
                visitor.visit(this, this.keys[i], this.children[i]);
            }
        }

        @Override
        public void updateTransition(char c, TrieNode<T> node) {
            int defaultSlot;
            int currentSlot = defaultSlot = this.hash(c) & this.modulusMask;
            do {
                if (this.children[currentSlot] == null) {
                    throw new IllegalArgumentException("Transition for " + c + " doesn't exist.");
                }
                if (this.keys[currentSlot] == c) {
                    this.children[currentSlot] = node;
                    return;
                }
                ++currentSlot;
            } while ((currentSlot &= this.modulusMask) != defaultSlot);
            throw new IllegalArgumentException("Transition for " + c + " doesn't exist.");
        }

        @Override
        protected TrieNode<T> optimizeNode(int level, Thresholder thresholdStrategy) {
            char minKey = '\uffff';
            char maxKey = '\u0000';
            int size = this.numEntries;
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i] == null) continue;
                if (this.keys[i] > maxKey) {
                    maxKey = this.keys[i];
                }
                if (this.keys[i] >= minKey) continue;
                minKey = this.keys[i];
            }
            int keyIntervalSize = maxKey - minKey + 1;
            if (this.defaultTransition != null || thresholdStrategy.isOverThreshold(size, level, keyIntervalSize)) {
                return new RangeNode(this, minKey, maxKey);
            }
            return this;
        }

        private void enlarge() {
            char[] biggerKeys = new char[this.keys.length * 2];
            TrieNode[] biggerChildren = new TrieNode[this.children.length * 2];
            int biggerMask = biggerKeys.length - 1;
            block0: for (int i = 0; i < this.children.length; ++i) {
                int defaultSlot;
                char key = this.keys[i];
                TrieNode<T> node = this.children[i];
                if (node == null) continue;
                int currentSlot = defaultSlot = this.hash(key) & biggerMask;
                do {
                    if (biggerChildren[currentSlot] == null) {
                        biggerKeys[currentSlot] = key;
                        biggerChildren[currentSlot] = node;
                        continue block0;
                    }
                    if (biggerKeys[currentSlot] == key) {
                        throw new IllegalStateException();
                    }
                    ++currentSlot;
                } while ((currentSlot &= biggerMask) != defaultSlot);
            }
            this.keys = biggerKeys;
            this.children = biggerChildren;
            this.modulusMask = biggerMask;
        }

        private HashmapNode<T> getOrAddChild(char key) {
            int defaultSlot;
            if (this.keys.length < 65536 && (this.numEntries >= this.keys.length || this.numEntries > 16 && (float)this.numEntries >= (float)this.keys.length * 0.9f)) {
                this.enlarge();
            }
            int currentSlot = defaultSlot = this.hash(key) & this.modulusMask;
            do {
                if (this.children[currentSlot] == null) {
                    this.keys[currentSlot] = key;
                    HashmapNode<T> newChild = new HashmapNode<T>(false);
                    this.children[currentSlot] = newChild;
                    ++this.numEntries;
                    return newChild;
                }
                if (this.keys[currentSlot] == key) {
                    return (HashmapNode)this.children[currentSlot];
                }
                ++currentSlot;
            } while ((currentSlot &= this.modulusMask) != defaultSlot);
            throw new IllegalStateException();
        }

        private int hash(char c) {
            int HASH_PRIME = 16777619;
            return ((0x811C9DC5 ^ c >> 8) * 16777619 ^ c & 0xFF) * 16777619;
        }
    }

    private static interface EntryVisitor<T> {
        public void visit(TrieNode<T> var1, char var2, TrieNode<T> var3);
    }
}

